local SlimUI = ThemePrefs.Get("GameplayMinimalUI")
local t = Def.ActorFrame {};
	t[#t+1] = LoadActor("ScreenFilter");

	t[#t+1] = LoadActor("_dead");	
	
	t[#t+1] = Def.Quad {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color("#000000"));
			OnCommand=cmd(decelerate,0.4;diffusealpha,0;);
	};
	
	t[#t+1] = LoadActor(THEME:GetPathG("_transition", "emblem")) .. {
				InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
				OnCommand=cmd(rotationz,60;diffusealpha,1;smooth,0.6;rotationz,0;zoom,0.3;diffusealpha,0;);
	};
	
		
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP-35);
		OnCommand=cmd(sleep,0.4;decelerate,0.3;addy,66;);
		OffCommand=cmd(sleep,0.6;smooth,0.3;addy,-60;);
	
	LoadActor("_frame") .. {
		OnCommand=function(self)
			if SlimUI == true and GAMESTATE:GetPlayMode() ~= 'PlayMode_Rave' then
				self:addy(-30);
			end;
		end;
	};
	
	LoadFont("_troika 24px") .. {
		InitCommand=cmd(horizalign,center;addy,-10;);
		OnCommand=function(self)
			if SlimUI == true then
				self:visible(false);
			end;
		end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP2ChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local curScreen = Var "LoadingScreen";
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1;
			local playMode = GAMESTATE:GetPlayMode();
			local curStage = GAMESTATE:GetCurrentStage();
			if GAMESTATE:IsCourseMode() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then
					return
				end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			else
				if GAMESTATE:IsEventMode() then
					self:settextf("FREE");
				else
					self:settextf("%s", ToEnumShortString(curStage));
				end
			end;
			self:zoom(0.75);
			self:diffuse(StageToColor(curStage));
			self:strokecolor(ColorDarkTone(StageToColor(curStage)));
		end;
	};
	
	};

	
	-- t[#t+1] = LoadActor("_screenstage") .. {
        -- OnCommand=cmd(sleep,0.3;queuecommand,("Play"));
		-- PlayCommand=cmd(play;);
		
    -- };
	
return t